      *  This demonstrates a simple SSL client program.  It connects
      *  to an SSL server on port 8765 (provided by the SSLSERVER source
      *  member.)  It asks that server for some customer info, and
      *  shows the result in a green-screen display file.
      *                                   Scott Klement, Sept 2006
      *
      *  To Compile:
      *    - Make sure you have the SOCKET_H, GSKSSL_H members uploaded
      *      and in a QRPGLESRC file in your library list.
      *    - Make sure you have the SSLCLIENTS source member uploaded
      *      and in a QDDSSRC file in your library list.
      *    - Change the server name on the ConnSock() call (below) to
      *      the name of the computer that's running the SSLSERVER
      *      program.
      *    - type:
      *      CRTDSPF FILE(SSLCLIENTS) SRCFILE(xxx/QDDSSRC)
      *    - type:
      *      CRTBNDRPG PGM(SSLCLIENT) SRCFILE(xxx/QRPGLESRC) DBGVIEW(*LIST)
      *
      *   Before running:
      *    - Configure an application profile for application id
      *      KLEMENT_SSLDEMO_SSLCLIENT in the Digital Certificate Manager
      *    - To do that:
      *        a) Connect to the DCM with your web browser on port 2001
      *               http://my-i5.example.com:2001
      *        b) Choose "Digital Certificate Manager"
      *        c) Select a certificate store, preferably *SYSTEM,
      *               and type the password.
      *        d) On the left, select "Manage Applications"
      *        e) Then select "Add Application"
      *        f) This is a client application.  Make sure you use
      *               KLEMENT_SSLDEMO_SSLCLIENT as the application id
      *               (or change this code to use the appid that you
      *               provided!)
      *
      *    If you have trouble getting this running, a great place to go
      *    for help is the iSeries Network Forums:
      *          http://www.iseriesnetwork.com/isnetforums/
      *
      *    To run:
      *       CALL SSLCLIENT
      *
      *    Hint:  If you get a "Connection Refused" error message, it
      *           means that you haven't started the SSLSERVER program.
      *           See the comments in SSLSERVER member for more info.
      *
     H DFTACTGRP(*NO) BNDDIR('QC2LE')

     FSSLCLIENTSCF   E             WORKSTN IndDs(dsIndic)

      /copy socket_h
      /copy gskssl_h

     D dsIndic         ds
     D   ExitKey                      1N   overlay(dsIndic:03)

     D CustData        ds                  qualified
     D   Error                        1N   inz(*OFF)
     D   ErrorMsg                    60A
     D   Name                        25A
     D   Street                      25A
     D   City                        25A
     D   State                        2A
     D   Zip                         10A

     D CreateEnv       PR                  like(gsk_handle)
     D ConnSock        PR            10I 0
     d   host                       256A   const
     D   port                        10I 0 value
     D UpgradeSock     PR                  like(gsk_handle)
     D    SslEnv                           like(gsk_handle) value
     D    sock                       10I 0 value
     D GetCustNumber   PR             1N
     D GetCustInfo     PR             1N
     D   CustNo                       4S 0 value
     D   Data                              likeds(CustData)
     D showCustinfo    PR
     D CloseSsl        PR
     D    Handle                           like(gsk_handle) value
     D CloseSslEnv     PR
     D    SslEnv                           like(gsk_handle) value
     D ReportError     PR
     D EscapeMsg       PR
     D errMsg          s             80A   varying

     D CRLF            c                   x'0d25'
     D env             s                   like(gsk_handle)
     D s               s             10I 0
     D connto          ds                  likeds(sockaddr_in)
     D SslSock         s                   like(gsk_handle)
     D cmd             s            400A
     D len             s             10I 0
     D bytesSent       s             10I 0
     D Reply           s           1000A
     D bytesRead       s             10I 0
     D left            s             10I 0
     D buf             s               *
     D received        s             10I 0
     D dataPos         s             10I 0
     D wait            s              1A
     D rc              s             10I 0


      /free

         // Create an SSL environment

         env = CreateEnv();
         if (env = *NULL);
            EscapeMsg();
         endif;

         // Connect a socket to an SSL server (using normal socket
         //  calls )
         //
         // FIXME:  CHANGE THIS to the name of the computer that's
         //         running the SSLSERVER program!!

         s = ConnSock('as400.example.com': 8765);

         // Upgrade the socket to SSL

         SSLSock = UpgradeSock(env: s);
         if (SSLSock = *NULL);
            EscapeMsg();
         endif;

         // Get Customer number from user and
         //  display info on screen

         dow getCustNumber();
            if (getCustInfo(CustNo: CustData));
               showCustInfo();
            endif;
         enddo;

         // Close everything and end the prgoram.

         CloseSsl(SslSock);
         CloseSslEnv(Env);
         *inlr = *on;
      /end-free


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * CreateEnv(): Create an SSL environment for client sockets
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P CreateEnv       B
     D CreateEnv       PI                  like(gsk_handle)
     D rc              s             10I 0
     D SslEnv          s                   like(Gsk_handle)
      /free

        // Create an SSL environment with default values:

         rc = gsk_environment_open(SslEnv);
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            return *NULL;
         endif;

        // Tell the environment to use the *SYSTEM certificate
        //  store

         rc = gsk_attribute_set_buffer( SslEnv
                                      : GSK_OS400_APPLICATION_ID
                                      : 'KLEMENT_SSLDEMO_SSLCLIENT'
                                      : 0 );
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            gsk_environment_close( SslEnv );
            return *NULL;
         endif;

        // Tell the environment that this is a client connection

         rc = gsk_attribute_set_enum( SslEnv
                                    : GSK_SESSION_TYPE
                                    : GSK_CLIENT_SESSION );
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            gsk_environment_close( SslEnv );
            return *NULL;
         endif;

        // Activate the new environment.

         rc = gsk_environment_init( SslEnv );
         if (rc <> GSK_OK);
            errMsg = %str(gsk_strerror(rc));
            gsk_environment_close( SslEnv );
            return *NULL;
         endif;

         return SslEnv;
      /end-free
     P                 E

      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * ConnSock(): Create a TCP Socket and connect to a host
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P ConnSock        B
     D ConnSock        PI            10I 0
     d   host                       256A   const
     D   port                        10I 0 value
     D s               s             10I 0
     D addr            s             10U 0
      /free

         // look up host

         addr = inet_addr(%trim(host));
         if (addr = INADDR_NONE);
             p_hostent = gethostbyname(%trim(host));
             if (p_hostent = *NULL);
                 errMsg = 'Host not found!';
                 EscapeMsg();
             endif;
             addr = h_addr;
         endif;

         // Create a socket

         s = socket(AF_INET: SOCK_STREAM: IPPROTO_IP);
         if (s < 0);
            ReportError();
         endif;

         // connect to the host

         connto = *ALLx'00';
         connto.sin_family = AF_INET;
         connto.sin_addr   = addr;
         connto.sin_port   = port;

         if (connect(s: %addr(Connto): %size(connto)) = -1);
            callp close(S);
            ReportError();
         endif;

         return s;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * UpgradeSock():  Upgrade a socket to use SSL
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P UpgradeSock     B
     D UpgradeSock     PI                  like(gsk_handle)
     D    SslEnv                           like(gsk_handle) value
     D    sock                       10I 0 value
     D Handle          s                   like(Gsk_handle)
      /free
          rc = gsk_secure_soc_open(SslEnv: Handle);
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             return *NULL;
          endif;

          rc = gsk_attribute_set_numeric_value( Handle
                                              : GSK_HANDSHAKE_TIMEOUT
                                              : 30 );
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             gsk_secure_soc_close(Handle);
             return *NULL;
          endif;

          rc = gsk_attribute_set_numeric_value( Handle
                                              : GSK_FD
                                              : sock );
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             gsk_secure_soc_close(Handle);
             return *NULL;
          endif;

          rc = gsk_secure_soc_init( Handle );
          if (rc <> GSK_OK);
             errMsg = %str(gsk_strerror(rc));
             gsk_secure_soc_close(Handle);
             return *NULL;
          endif;

          return Handle;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * GetCustNumber(): Ask user for customer number
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P GetCustNumber   B
     D GetCustNumber   PI             1N
      /free
          if (CustData.Error);
             Msg = CustData.errorMsg;
          else;
             Msg = *blanks;
          endif;

          exfmt SSLCLIENT1;
          CustData.Error = *OFF;

          if (ExitKey);
             return *OFF;
          endif;

          return *ON;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * GetCustInfo(): Request customer info from SSL server
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P GetCustInfo     B
     D GetCustInfo     PI             1N
     D   CustNo                       4S 0 value
     D   Data                              likeds(CustData)

     D Req             ds                  qualified
     D   cmd                          4A
     D   CustNo                       4S 0

     D len             s             10I 0
     D rc              s             10I 0
     D totalRecv       s             10I 0

      /free

         //  Send a customer number request to the server

         req.cmd    = 'CUST';
         req.CustNo = CustNo;

         rc = gsk_secure_soc_write( SSLSock
                                  : %addr(Req)
                                  : %size(Req)
                                  : bytesSent );
         if (rc <> GSK_OK);
             data.error = *ON;
             data.errorMsg = %str(gsk_strerror(rc));
             return *OFF;
         endif;

         //  Receive data in a loop til we receive the whole
         //  CustData data structure

         totalRecv = 0;
         dou totalRecv = %size(data);

             rc = gsk_secure_soc_read( SSLSock
                                     : %addr(data) + totalRecv
                                     : %size(data) - totalRecv
                                     : len );
             if (rc <> GSK_OK);
                data.error = *ON;
                data.errorMsg = %str(gsk_strerror(rc));
                return *OFF;
             endif;

             totalRecv = totalRecv + len;
         enddo;

         return (not data.error);
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * showCustInfo(): Display Customer info on screen
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P showCustInfo    B
     D showCustinfo    PI
      /free
          Name   = CustData.Name;
          Street = CustData.Street;
          City   = CustData.City;
          State  = CustData.State;
          Zip    = CustData.Zip;
          exfmt SSLCLIENT2;
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * CloseSsl():  Close an SSL socket
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P CloseSsl        B
     D CloseSsl        PI
     D    Handle                           like(gsk_handle) value
      /free
           gsk_secure_Soc_close( handle);
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * CloseSslEnv():  Close SSL Environment
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P CloseSslEnv     B
     D CloseSslEnv     PI
     D    SslEnv                           like(gsk_handle) value
      /free
           gsk_environment_close( SslEnv );
      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * EscapeMsg(): Send an escape message w/reason for SSL failure
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P EscapeMsg       B
     D EscapeMsg       PI

     D SndPgmMsg       PR                  ExtPgm('QMHSNDPM')
     D   MessageID                    7A   Const
     D   QualMsgF                    20A   Const
     D   MsgData                    256A   Const
     D   MsgDtaLen                   10I 0 Const
     D   MsgType                     10A   Const
     D   CallStkEnt                  10A   Const
     D   CallStkCnt                  10I 0 Const
     D   MessageKey                   4A
     D   ErrorCode                    1A

     D ErrorCode       DS
     D  BytesProv                    10I 0 inz(0)
     D  BytesAvail                   10I 0 inz(0)

     D wwTheKey        S              4A
      /free

           SndPgmMsg( 'CPF9897'
                    : 'QCPFMSG   *LIBL'
                    : errMsg
                    : %len(%trimr(errMsg))
                    : '*ESCAPE'
                    : '*CTLBDY'
                    : 1
                    : wwTheKey
                    : ErrorCode );

      /end-free
     P                 E


      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      * ReportError():  Send an escape message explaining any errors
      *                 that occurred.
      *
      *  This function requires binding directory QC2LE in order
      *  to access the __errno() function.
      *+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     P ReportError     B
     D ReportError     PI

     D get_errno       PR              *   ExtProc('__errno')
     D ptrToErrno      s               *
     D errno           s             10I 0 based(ptrToErrno)

     D QMHSNDPM        PR                  ExtPgm('QMHSNDPM')
     D   MessageID                    7A   Const
     D   QualMsgF                    20A   Const
     D   MsgData                      1A   Const
     D   MsgDtaLen                   10I 0 Const
     D   MsgType                     10A   Const
     D   CallStkEnt                  10A   Const
     D   CallStkCnt                  10I 0 Const
     D   MessageKey                   4A
     D   ErrorCode                 8192A   options(*varsize)

     D ErrorCode       DS                  qualified
     D  BytesProv              1      4I 0 inz(0)
     D  BytesAvail             5      8I 0 inz(0)

     D MsgKey          S              4A
     D MsgID           s              7A

      /free

         ptrToErrno = get_errno();
         MsgID = 'CPE' + %char(errno);

         QMHSNDPM( MsgID
                 : 'QCPFMSG   *LIBL'
                 : ' '
                 : 0
                 : '*ESCAPE'
                 : '*PGMBDY'
                 : 1
                 : MsgKey
                 : ErrorCode         );

      /end-free
     P                 E
